export const nearby = <T extends unknown>(array: T[]): [T, T][] => {
  if (array.length <= 1) {
    return [];
  }

  const result: [T, T][] = [];
  let i = 0;
  while (i < array.length - 1) {
    result.push([array[i], array[i + 1]]);
    i++;
  }
  return result;
};
