import React, { useState } from 'react';
import { FocusNode } from './FocusNode';
import { FocusScope } from './FocusScope';

export const Toggle = () => {
  const [isEditing, setEditing] = useState(false);

  const toggle = () => {
    setEditing(!isEditing);
  };

  return isEditing ? (
    <FocusNode>
      <button onClick={toggle}>on</button>
    </FocusNode>
  ) : (
    <FocusNode>
      <button onClick={toggle}>off</button>
    </FocusNode>
  );
};

export const Default = () => {
  return (
    <div>
      <FocusScope>
        <FocusNode>
          <input type="text" placeholder="input in scope" />
        </FocusNode>
        <FocusNode>
          <input type="text" placeholder="input in scope" />
        </FocusNode>
        <FocusNode>
          <button>button in scope</button>
        </FocusNode>
        <FocusNode>
          <button>button in scope</button>
        </FocusNode>
      </FocusScope>

      <button>button</button>

      <FocusScope>
        <FocusNode>
          <input type="text" placeholder="input in scope" />
        </FocusNode>
        <Toggle />
        <FocusNode>
          <button>button in scope</button>
        </FocusNode>
        <div style={{ paddingLeft: 20 }}>
          <FocusScope>
            nested scope
            <FocusNode>
              <input type="text" placeholder="input in scope" />
            </FocusNode>
            <FocusNode>
              <button>button in scope</button>
            </FocusNode>
            <div style={{ paddingLeft: 40 }}>
              <FocusScope>
                nested scope x2
                <FocusNode>
                  <input type="text" placeholder="input in scope" />
                </FocusNode>
                <FocusNode>
                  <button>button in scope</button>
                </FocusNode>
              </FocusScope>
            </div>
          </FocusScope>
        </div>
      </FocusScope>

      <input type="text" placeholder="input" style={{ marginBottom: 50 }} />
    </div>
  );
};

export default {
  title: 'FocusScope',
  component: FocusScope,
};
