import { createElement } from 'react';
import cx from 'classnames';
import { THEME } from './constants';
import css from './Form.modules.scss';

const Form = (props) => {
  const { theme } = props;
  const className = cx(props.className, css.Form, css[`Form_theme_${theme}`]);

  return createElement('form', { ...props, className });
};

Form.defaultProps = {
  theme: THEME.DEFAULT,
};

export default Form;
