import { Form } from 'types/api/form/Form';

const longText = `Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s,`;
const selectItems = [
  {
    id: '0',
    name: '1 месяц',
  },
  {
    id: '1',
    name: '3 месяца',
  },
  {
    id: '2',
    name: '6 месяцев',
  },
  {
    id: '3',
    name: '9 месяцев',
  },
];
const currencyItems = [
  {
    code: 'client',
    id: 1,
    name: 'Валюта клиента',
  },
  {
    code: 'rub',
    id: 2,
    name: 'Рубли',
  },
  {
    code: 'byn',
    id: 3,
    name: 'Бел. рубли',
  },
  {
    code: 'kzt',
    id: 4,
    name: 'Тенге',
  },
  {
    code: 'eur',
    id: 5,
    name: 'Евро',
  },
  {
    code: 'usd',
    id: 6,
    name: 'Доллары',
  },
  {
    code: 'chf',
    id: 7,
    name: 'Швейц. франки',
  },
  {
    code: 'uzs',
    id: 8,
    name: 'Сум',
  },
];

const data = [
  {
    id: '1',
    fields: [
      {
        id: 'MoneyCount',
        type: 'Digit',
        data: {
          value: 1000,
        },
      },
      {
        id: 'MoneyValue',
        type: 'Money',
        data: {
          value: -4,
          currency: {
            code: 'kzt',
            id: 4,
            name: 'Тенге',
          },
        },
      },
      {
        id: 'MoneyValueEmpty',
        type: 'Money',
      },
      {
        id: 'description',
        type: 'Text',
        data: {
          value: 'CommonDescription',
        },
      },
      {
        id: 'description2',
        type: 'Text',
        data: {
          value: 'MainDirections',
        },
      },
      {
        id: 'description3',
        type: 'Textarea',
        data: {
          value: `Длинный как шланг текст - ${longText}`,
        },
      },
      {
        id: 'description4',
        type: 'Textarea',
        data: {
          value: `Длинный как шланг текст - ${longText}`,
        },
      },
      {
        id: 'TextareaEmpty',
        type: 'Textarea',
      },
      {
        id: 'PlanningPeriod',
        type: 'Select',
        data: {
          id: '2',
          name: '6 месяцев',
        },
      },
      {
        id: 'PlanningPeriod2',
        type: 'Select',
        data: {
          id: '2',
          name: '6 месяцев',
        },
      },
      {
        id: 'SelectEmpty',
        type: 'Select',
      },
      {
        id: 'PlacementPeriodicity',
        type: 'SelectArray',
        data: {
          value: [
            {
              id: '1',
              name: '3 месяца',
            },
            {
              id: '2',
              name: '6 месяцев',
            },
          ],
        },
      },
      {
        id: 'PlacementPeriodicity2',
        type: 'SelectArray',
        data: {
          value: [
            {
              id: '0',
              name: 'янв',
            },
            {
              id: '1',
              name: 'фев',
            },
          ],
        },
      },
      {
        id: 'Regions',
        type: 'SuggestArray',
        data: {
          value: [
            {
              id: '1',
              name: 'Asia',
            },
            {
              id: '2',
              name: 'Booking',
            },
            {
              id: '3',
              name: 'DACH',
            },
          ],
        },
      },
      {
        id: 'Regions2',
        type: 'SuggestArray',
        data: {
          value: [
            {
              id: '1',
              name: 'Asia',
            },
            {
              id: '2',
              name: 'Booking',
            },
            {
              id: '3',
              name: 'DACH',
            },
          ],
        },
      },
      {
        id: 'Regions3',
        type: 'Suggest',
        data: {
          value: {
            id: '2',
            name: 'Booking',
          },
        },
      },
      {
        id: 'SuggestEmpty',
        type: 'Suggest',
      },
      {
        id: 'Tags',
        type: 'Tags',
        data: {
          value: [
            {
              id: '2',
              name: 'Tag 1',
              color: '#f55',
            },
            {
              id: '3',
              name: 'Tag 2',
              color: '#5f5',
            },
          ],
        },
      },
    ],
  },
];

export const formScheme: Form = {
  data,
  meta: {
    fieldsVisibility: [
      'MoneyCount',
      'MoneyValue',
      'MoneyValueEmpty',
      'description',
      'description2',
      'description3',
      'description4',
      'TextareaEmpty',
      'PlanningPeriod',
      'PlanningPeriod2',
      'SelectEmpty',
      'PlacementPeriodicity',
      'PlacementPeriodicity2',
      'Regions',
      'Regions2',
      'Regions3',
      'SuggestEmpty',
      'Tags',
    ],

    fields: [
      {
        id: 'MoneyCount',
        title: 'Объем бюджета в рублях',
        type: 'Digit',
        access: 3,
        isFieldsUpdateNeeded: false,
      },
      {
        id: 'MoneyValue',
        title: 'Объем бюджета на выбранный период',
        type: 'Money',
        access: 3,
        items: currencyItems,
        isFieldsUpdateNeeded: false,
      },
      {
        id: 'MoneyValueEmpty',
        title: 'Объем бюджета на выбранный период',
        type: 'Money',
        access: 3,
        items: currencyItems,
        isFieldsUpdateNeeded: false,
      },
      {
        id: 'description',
        type: 'Text',
        title: 'Общее описание',
        access: 3,
        isFieldsUpdateNeeded: false,
      },
      {
        id: 'description2',
        type: 'Text',
        title: 'Основные направления',
        access: 1,
        isFieldsUpdateNeeded: false,
      },
      {
        id: 'description3',
        type: 'Textarea',
        title: 'Полное Описание',
        access: 3,
        isFieldsUpdateNeeded: false,
      },
      {
        id: 'description4',
        type: 'Textarea',
        title: 'Полное Описание(disabled)',
        access: 1,
        isFieldsUpdateNeeded: false,
      },
      {
        id: 'TextareaEmpty',
        type: 'Textarea',
        title: 'Полное Описание(empty)',
        access: 3,
        isFieldsUpdateNeeded: false,
      },
      {
        id: 'PlanningPeriod',
        type: 'Select',
        access: 3,
        title: 'Подход к планированию',
        items: selectItems,
        isFieldsUpdateNeeded: false,
      },
      {
        id: 'PlanningPeriod2',
        type: 'Select',
        access: 1,
        title: 'Подход к планированию',
        items: selectItems,
        isFieldsUpdateNeeded: false,
      },
      {
        id: 'SelectEmpty',
        type: 'Select',
        access: 3,
        title: 'Подход к планированию(empty)',
        items: selectItems,
        isFieldsUpdateNeeded: false,
      },
      {
        id: 'PlacementPeriodicity',
        type: 'SelectArray',
        access: 3,
        title: 'Периодичность размещения',
        items: [
          {
            id: '0',
            name: 'янв',
          },
          {
            id: '1',
            name: 'фев',
          },
        ],
        isFieldsUpdateNeeded: false,
      },
      {
        id: 'PlacementPeriodicity2',
        type: 'SelectArray',
        access: 1,
        title: 'Периодичность размещения 2',
        items: [
          {
            id: '0',
            name: 'янв',
          },
          {
            id: '1',
            name: 'фев',
          },
        ],
        isFieldsUpdateNeeded: false,
      },
      {
        id: 'Regions',
        type: 'SuggestArray',
        access: 3,
        title: 'Регионы размещения',
        provider: '/view/dicts/territory',
        isFieldsUpdateNeeded: false,
      },
      {
        id: 'Regions2',
        type: 'SuggestArray',
        access: 1,
        title: 'Регионы размещения',
        provider: '/view/dicts/territory',
        isFieldsUpdateNeeded: false,
      },
      {
        id: 'Regions3',
        type: 'Suggest',
        access: 3,
        title: 'Регионы размещения3',
        provider: '/view/dicts/territory',
        isFieldsUpdateNeeded: false,
      },
      {
        id: 'SuggestEmpty',
        type: 'Suggest',
        access: 3,
        title: 'Регионы размещения3(empty)',
        provider: '/view/dicts/territory',
        isFieldsUpdateNeeded: false,
      },
      {
        id: 'Tags',
        type: 'Tags',
        access: 3,
        title: 'Теги',
        provider: '/tags',
        isFieldsUpdateNeeded: false,
      },
    ],
  },
};
