import React from 'react';
import { Form } from 'types/api/form/Form';
import { FormByScheme } from '../FormByScheme';
import { formatFormValuesToDataSet } from '../utils/formatFormValuesToDataSet';

export const createForm = (formScheme: Form) => {
  const handleSubmitForm = (values) => {
    // eslint-disable-next-line no-console
    console.log(JSON.stringify(formatFormValuesToDataSet(values, formScheme), null, 2));
  };

  return () => {
    return <FormByScheme onSubmit={handleSubmitForm} scheme={formScheme} />;
  };
};
