import React from 'react';
import { Form } from 'types/api/form/Form';
import { FormBySchemeToggleable } from '../FormBySchemeToggleable';
import { formatFormValuesToDataSet } from '../utils/formatFormValuesToDataSet';

export const createFormToggleable = (formScheme: Form) => {
  const handleSubmitForm = (values) => {
    // eslint-disable-next-line no-console
    console.log(JSON.stringify(formatFormValuesToDataSet(values, formScheme), null, 2));
  };

  return () => {
    return <FormBySchemeToggleable size="s" onSubmit={handleSubmitForm} scheme={formScheme} />;
  };
};
