import React, { ComponentType } from 'react';
import { ComponentStory } from '@storybook/react';
import { rest } from 'msw';
import { FormBySchemeProps } from '../FormByScheme';
import { createForm } from './form';
import { createFormToggleable } from './formToggleable';
import { FormBySchemePreview } from '../FormBySchemePreview';
import { formScheme } from './form.config';

export default {
  title: 'FormByScheme',
};

export const form: ComponentStory<ComponentType<FormBySchemeProps>> = createForm(formScheme);

form.parameters = {
  msw: {
    handlers: [
      rest.get('*/tags', (req, res, ctx) => {
        return res(
          ctx.json({
            items: [
              {
                id: 101,
                name: 'Tag 1',
              },
              {
                id: 102,
                name: 'Tag 2',
              },
            ],
          }),
        );
      }),
    ],
  },
};

export const formToggleable = createFormToggleable(formScheme);
export const preview = () => <FormBySchemePreview scheme={formScheme} />;
