import React, { FC, memo, useMemo } from 'react';
import { Form } from 'components/FinalForm/Form';
import { Scrollable } from '@crm/components/dist/Scrollable';
import { FormBySchemeProps } from './FormByScheme.types';
import { FormBySchemeFields } from '../FormBySchemeFields';
import { OptionalSending } from '../services/OptionalSending';

const hasOptionalSending = (scheme: FormBySchemeProps['scheme']) => {
  return scheme.meta.fields.find((field) => field.isOptionalSending);
};

export const FormByScheme: FC<FormBySchemeProps> = memo((props) => {
  const { scheme, size = 'm', ...other } = props;
  const optionalSendingService = useMemo(
    () =>
      hasOptionalSending(scheme)
        ? new OptionalSending(scheme, other.onSubmit, other.onChange)
        : undefined,
    [scheme, other.onChange, other.onSubmit],
  );
  const formSubmitHandler = optionalSendingService?.onSubmit || other.onSubmit;
  const formChangeHandler = optionalSendingService?.onChange || other.onChange;
  return (
    <Form size={size} {...other} onChange={formChangeHandler} onSubmit={formSubmitHandler}>
      <Scrollable withModalPadding>
        <FormBySchemeFields
          optionalSendingService={optionalSendingService}
          scheme={scheme}
          size={size}
          isFormMode
        />
      </Scrollable>
    </Form>
  );
});
