/* eslint-disable @typescript-eslint/no-explicit-any */
import React, { FC, memo } from 'react';
import { FieldAny } from 'types/api/form/Form';
import Access from 'utils/Access';
import { observer } from 'mobx-react-lite';
import { Row } from '../Row';
import { adapters } from '../adapters';
import { FormBySchemeFieldsProps } from './FormBySchemeFields.types';
import { UnknownField } from '../UnknownField';
import { SelectFieldComponent } from './SelectFieldComponent';

export const FormBySchemeFields: FC<FormBySchemeFieldsProps> = memo(
  observer((props) => {
    const { scheme, size = 'm', isFormMode, optionalSendingService } = props;
    const editableRow = scheme.data[0];
    if (!editableRow) {
      return null;
    }

    const renderField = (field: FieldAny) => {
      const adapter = adapters[field.type];
      if (!adapter) {
        return <UnknownField size={size} field={field} />;
      }

      if (isFormMode && Access.isEdit(field.access)) {
        return <adapter.editComponent field={field} size={size} />;
      }

      return <adapter.previewComponent field={field} size={size} />;
    };

    const renderRow = (rowId: string) => {
      const row = scheme.meta.fields.find((field) => field.id === rowId);
      if (!row) {
        return null;
      }

      const fieldData = editableRow.fields.find((field) => field.id === rowId);
      if (!fieldData) {
        return null;
      }
      const field = { ...row, data: fieldData.data };
      let isSelected;
      let onFieldSelect;
      if (optionalSendingService) {
        const fieldKey = field.type + field.id;
        isSelected = optionalSendingService.isFieldSelected(fieldKey);
        onFieldSelect = () => {
          optionalSendingService.toggleFieldSelecting(fieldKey);
        };
      }
      return (
        <Row
          SelectFieldComponent={() => (
            <SelectFieldComponent onChange={onFieldSelect} isSelected={isSelected} />
          )}
          key={field.id}
          label={field.title}
          size={size}
        >
          {renderField(field)}
        </Row>
      );
    };

    return <>{scheme.meta.fieldsVisibility.map(renderRow)}</>;
  }),
);
