import React, { FC, memo } from 'react';
import Button from '@crm/components/dist/lego2/Button';
import Toolbar from 'components/Toolbar';
import { FormBySchemeFields } from '../FormBySchemeFields';
import { FormBySchemePreviewProps } from './FormBySchemePreview.types';
import css from './FormBySchemePreview.module.css';

export const FormBySchemePreview: FC<FormBySchemePreviewProps> = memo((props) => {
  const { scheme, onEdit, onDelete, size } = props;

  return (
    <div>
      <div>
        <FormBySchemeFields scheme={scheme} size={size} />
      </div>
      {(onEdit || onDelete) && (
        <Toolbar className={css.FormBySchemePreview__toolbar}>
          {onEdit && (
            <Button size={size} onClick={onEdit}>
              Редактировать
            </Button>
          )}
          {onDelete && (
            <Button size={size} onClick={onDelete}>
              Удалить
            </Button>
          )}
        </Toolbar>
      )}
    </div>
  );
});
