import React, { useState, useCallback } from 'react';
import { FormBySchemePreview } from '../FormBySchemePreview';
import { FormByScheme } from '../FormByScheme';
import { FormBySchemeToggleableProps } from './FormBySchemeToggleable.types';

export const FormBySchemeToggleable = (props: FormBySchemeToggleableProps) => {
  const {
    defaultIsEdit,
    canEdit = true,
    scheme,
    onSubmitSuccess,
    size = 's',
    ...otherProps
  } = props;

  const [isEdit, setIsEdit] = useState(Boolean(defaultIsEdit));

  const handleEdit = useCallback(() => {
    setIsEdit(true);
  }, []);

  const handleSubmitSuccess = useCallback(
    (...args) => {
      if (onSubmitSuccess) {
        onSubmitSuccess(...args);
      }

      setIsEdit(false);
    },
    [onSubmitSuccess],
  );

  const handleCancel = useCallback(() => {
    setIsEdit(false);
  }, []);

  if (isEdit) {
    return (
      <FormByScheme
        footerAlign="start"
        scheme={scheme}
        onSubmitSuccess={handleSubmitSuccess}
        onCancel={handleCancel}
        size={size}
        {...otherProps}
      />
    );
  }

  return (
    <FormBySchemePreview size={size} scheme={scheme} onEdit={canEdit ? handleEdit : undefined} />
  );
};
