import React from 'react';
import { PreviewValue } from 'components/PreviewValue/PreviewValue';
import { Field } from 'react-final-form';
import AccountInput from 'lego/final-form/AccountInput';
import { AccountField } from 'types/api/form/Fields/Account';
import { FormTextAlign } from 'lego/components/FormTextAlign';
import { Adapter } from '../types/Adapter';

const getInitialValue = (field: AccountField['merged']) => field.data;

export const AccountAdapter: Adapter<AccountField['merged']> = {
  editComponent: (props) => {
    return (
      <Field
        name={props.field.type + props.field.id}
        component={AccountInput}
        initialValue={getInitialValue(props.field)}
        size={props.size}
      />
    );
  },
  previewComponent: (props) => {
    return (
      <FormTextAlign as="div" size={props.size}>
        <PreviewValue value={props.field?.data?.name} />
      </FormTextAlign>
    );
  },
  getInitialValue,
};
