import React from 'react';
import { audioRecordSrc } from 'utils/audioRecordSrc';
import { audioMetaSrc } from 'utils/audioMetaSrc';
import { useGlobalAudioContext } from 'modules/audio';
import { AudioSource } from 'components/AudioSource';
import { AudioField, AudioData } from 'types/api/form/Fields/Audio';
import { Adapter } from '../types/Adapter';

const getInitialValue = (field: AudioField['merged']) => field.data;

const AudioPlayer = (data: AudioData) => {
  const audio = useGlobalAudioContext();

  return (
    <AudioSource
      audio={audio}
      src={audioRecordSrc(data.callid)}
      metaSrc={audioMetaSrc(data.callid)}
      keepPlayOnUnmount={false}
    />
  );
};

export const AudioAdapter: Adapter<AudioField['merged']> = {
  editComponent: (props) => {
    return <AudioPlayer callid={props.field.data?.callid!} />;
  },
  previewComponent: (props) => {
    return <AudioPlayer callid={props.field.data?.callid!} />;
  },
  getInitialValue,
};
