import React from 'react';
import { observer } from 'mobx-react-lite';
import {
  AvailabilityPeriodsField,
  AvailabilityPeriods,
} from 'types/api/form/Fields/AvailabilityPeriods';
import { EventWidget, useWidgetApiService } from 'components/EventWidget';
import { Adapter } from '../types/Adapter';

const getInitialValue = (field: AvailabilityPeriodsField['merged']) => field.data;

const getBookingRange = (data: AvailabilityPeriods) => {
  if (!data.bookingFromDateTime || !data.bookingToDateTime) return;
  return {
    start: new Date(data.bookingFromDateTime),
    end: new Date(data.bookingToDateTime),
  };
};

const EventWidgetWithApi = observer<AvailabilityPeriods>((data) => {
  const widgetProps = useWidgetApiService(data);
  const bookingRange = getBookingRange(data);

  return (
    <div style={{ paddingLeft: 150 }}>
      <EventWidget {...widgetProps} bookingRange={bookingRange} />
    </div>
  );
});

export const AvailabilityPeriodsAdapter: Adapter<AvailabilityPeriodsField['merged']> = {
  editComponent: (props) => {
    const data = props.field.data as AvailabilityPeriods;
    return <EventWidgetWithApi {...data} />;
  },
  previewComponent: (props) => {
    const data = props.field.data as AvailabilityPeriods;
    return <EventWidgetWithApi {...data} />;
  },
  getInitialValue,
};
