import React from 'react';
import { Field } from 'react-final-form';
import Checkbox from 'lego/final-form/CheckBox';
import LegoCheckbox from '@crm/components/dist/lego2/Checkbox';
import { CheckboxField } from 'types/api/form/Fields/Checkbox';
import { FormTextAlign } from 'lego/components/FormTextAlign';
import { Adapter } from '../types/Adapter';

const getInitialValue = (field: CheckboxField['merged']) => field.data?.value;

export const CheckboxAdapter: Adapter<CheckboxField['merged']> = {
  editComponent: (props) => {
    return (
      <Field
        name={props.field.type + props.field.id}
        component={Checkbox}
        initialValue={getInitialValue(props.field)}
        size={props.size}
      />
    );
  },
  previewComponent: (props) => {
    return (
      <FormTextAlign as="div" size={props.size}>
        <LegoCheckbox disabled checked={props.field.data?.value} />
      </FormTextAlign>
    );
  },
  getInitialValue,
};
