import React from 'react';
import { PreviewValue } from 'components/PreviewValue/PreviewValue';
import { Field } from 'react-final-form';
import { FormattedDate } from 'react-intl';
import DateTimeInput from 'lego/final-form/DateTimeInput';
import { DateTimeField } from 'types/api/form/Fields/DateTime';
import { FormTextAlign } from 'lego/components/FormTextAlign';
import { Adapter } from '../types/Adapter';

const getInitialValue = (field: DateTimeField['merged']) => field.data?.value;

export const DateTimeAdapter: Adapter<DateTimeField['merged']> = {
  editComponent: (props) => {
    const valueType = props.field?.options?.valueType || 'DateTime';
    return (
      <Field
        name={props.field.type + props.field.id}
        component={DateTimeInput}
        time={valueType === 'DateTime'}
        nullable
        initialValue={getInitialValue(props.field)}
        size={props.size}
      />
    );
  },
  previewComponent: (props) => {
    const onlyDate = props.field.options?.valueType === 'Date';
    const timeSettings = onlyDate ? {} : { hour: 'numeric', minute: 'numeric' };
    return (
      <FormTextAlign as="div" size={props.size}>
        <PreviewValue
          component={FormattedDate}
          value={props.field.data?.value}
          year="numeric"
          month="numeric"
          day="numeric"
          {...timeSettings}
        />
      </FormTextAlign>
    );
  },
  getInitialValue,
};
