import React from 'react';
import { PreviewValue } from 'components/PreviewValue/PreviewValue';
import { Field } from 'react-final-form';
import TextInput from 'lego/final-form/TextInput';
import { DigitField } from 'types/api/form/Fields/Digit';
import { FormTextAlign } from 'lego/components/FormTextAlign';
import { Adapter } from '../types/Adapter';

const getInitialValue = (field: DigitField['merged']) => field.data?.value;

export const DigitAdapter: Adapter<DigitField['merged']> = {
  editComponent: (props) => {
    return (
      <Field
        name={props.field.type + props.field.id}
        component={TextInput}
        initialValue={getInitialValue(props.field)}
        size={props.size}
        type="number"
        hasClear={false}
      />
    );
  },
  previewComponent: (props) => {
    return (
      <FormTextAlign as="div" size={props.size}>
        <PreviewValue value={props.field.data?.value} />
      </FormTextAlign>
    );
  },
  getInitialValue,
};
