import React from 'react';
import { PreviewMoney } from 'components/PreviewValue/PreviewMoney';
import { Field } from 'react-final-form';
import MoneyInput from 'lego/final-form/Money';
import { MoneyField } from 'types/api/form/Fields/Money';
import { FormTextAlign } from 'lego/components/FormTextAlign';
import { Adapter } from '../types/Adapter';

const getInitialValue = (field: MoneyField['merged']) => field.data;

export const MoneyAdapter: Adapter<MoneyField['merged']> = {
  editComponent: (props) => {
    return (
      <Field
        name={props.field.type + props.field.id}
        component={MoneyInput}
        initialValue={getInitialValue(props.field)}
        currency={props.field.items}
        size={props.size}
      />
    );
  },
  previewComponent: (props) => {
    return (
      <FormTextAlign as="div" size={props.size}>
        <PreviewMoney value={props.field.data} />
      </FormTextAlign>
    );
  },
  getInitialValue,
};
