import React, { useMemo } from 'react';
import { Field } from 'react-final-form';
import { SuggestTagArrayField } from 'types/api/form/Fields/SuggestTagArray';
import { FormTextAlign } from 'lego/components/FormTextAlign';
import { get } from 'api/common';
import PreviewTags from 'components/PreviewValue/PreviewTags';
import Tags from 'lego/final-form/Tags';
import { Adapter } from '../types/Adapter';

const getInitialValue = (field: SuggestTagArrayField['merged']) => field.data?.value || [];

export const SuggestTagArrayAdapter: Adapter<SuggestTagArrayField['merged']> = {
  editComponent: function EditComponent(props) {
    const provider = props.field.provider;

    const loadTags = useMemo(() => (provider ? () => get({ url: provider }) : undefined), [
      provider,
    ]);

    return (
      <Field
        name={props.field.type + props.field.id}
        component={Tags}
        loadTags={loadTags}
        initialValue={getInitialValue(props.field)}
        size={props.size}
      />
    );
  },
  previewComponent: function PreviewComponent(props) {
    return (
      <FormTextAlign as="div" size={props.size}>
        <PreviewTags value={getInitialValue(props.field)} size={props.size} />
      </FormTextAlign>
    );
  },
  getInitialValue,
};
