import React from 'react';
import { PreviewValue } from 'components/PreviewValue/PreviewValue';
import { Field } from 'react-final-form';
import TextInput from 'lego/final-form/TextInput';
import { TextField } from 'types/api/form/Fields/Text';
import { FormTextAlign } from 'lego/components/FormTextAlign';
import { Adapter } from '../types/Adapter';

const getInitialValue = (field: TextField['merged']) => field.data?.value;

export const TextAdapter: Adapter<TextField['merged']> = {
  editComponent: (props) => {
    return (
      <Field
        name={props.field.type + props.field.id}
        component={TextInput}
        initialValue={getInitialValue(props.field)}
        size={props.size}
      />
    );
  },
  previewComponent: (props) => {
    return (
      <FormTextAlign as="div" size={props.size}>
        <PreviewValue value={props.field.data && props.field.data.value} />
      </FormTextAlign>
    );
  },
  getInitialValue,
};
