import React from 'react';
import { PreviewValue } from 'components/PreviewValue/PreviewValue';
import { Field } from 'react-final-form';
import Textarea from 'lego/final-form/TextArea';
import { TextareaField } from 'types/api/form/Fields/Textarea';
import { FormTextAlign } from 'lego/components/FormTextAlign';
import { Adapter } from '../types/Adapter';

const getInitialValue = (field: TextareaField['merged']) => field.data?.value;

export const TextareaAdapter: Adapter<TextareaField['merged']> = {
  editComponent: (props) => {
    return (
      <Field
        name={props.field.type + props.field.id}
        component={Textarea}
        initialValue={getInitialValue(props.field)}
        size={props.size}
        hasClear={false}
      />
    );
  },
  previewComponent: (props) => {
    return (
      <FormTextAlign as="div" size={props.size}>
        <PreviewValue value={props.field.data && props.field.data.value} />
      </FormTextAlign>
    );
  },
  getInitialValue,
};
