/* eslint-disable @typescript-eslint/no-explicit-any */
import React from 'react';
import { SelectBase } from 'types/api/form/Fields/SelectBase';
import { Option } from 'types/api/form/Fields/Option';
import { Field } from 'react-final-form';
import { FormTextAlign } from 'lego/components/FormTextAlign';
import Select from 'lego/final-form/Select';
import { SelectField } from 'types/api/form/Fields/Select';
import { SelectArrayField } from 'types/api/form/Fields/SelectArray';
import { ArrayPreviewDictionary } from 'components/PreviewValue/PreviewDictionary';
import { Adapter } from '../../types/Adapter';
import { valueToArray } from '../../utils/valueToArray';
import { getStringOrUndefined } from '../../utils/getStringOrUndefined';

const formatOption = (option: Option) => {
  return {
    value: getStringOrUndefined(option.id),
    content: option.name,
  };
};

const getInitialValue = (
  field: (SelectField & SelectArrayField)['merged'],
  isSingleValue: boolean,
) => {
  if (!field.data) return isSingleValue ? undefined : [];

  return isSingleValue
    ? getStringOrUndefined(field.data.id)
    : field.data.value.map((item) => getStringOrUndefined(item.id));
};

export const createSelectAdapter = <T extends SelectBase<any>>({
  isSingleValue,
}: {
  isSingleValue: boolean;
}): Adapter<T['merged']> => ({
  previewComponent(props) {
    return (
      <FormTextAlign as="div" size={props.size}>
        <ArrayPreviewDictionary
          value={valueToArray(isSingleValue ? props.field.data : props.field.data.value)}
        />
      </FormTextAlign>
    );
  },
  editComponent(props) {
    const bodyRef: React.RefObject<HTMLElement> = { current: document.body };
    return (
      <Field
        name={props.field.type + props.field.id}
        component={Select}
        initialValue={getInitialValue(props.field, isSingleValue)}
        size={props.size}
        options={(props.field.items || []).map(formatOption)}
        isSingleValue={isSingleValue}
        hasEmptyValue={false}
        castTo={String}
        unsafe_scope={bodyRef}
      />
    );
  },
  getInitialValue: (field) => getInitialValue(field, isSingleValue),
});
