import React from 'react';
import { Field } from 'react-final-form';
import { FormTextAlign } from 'lego/components/FormTextAlign';
import { SuggestField } from 'types/api/form/Fields/Suggest';
import { SuggestArrayField } from 'types/api/form/Fields/SuggestArray';
import UserSuggest from 'lego/final-form/UserSuggest';
import { ArrayPreviewDictionary } from 'components/PreviewValue/PreviewDictionary';
import { getStringOrUndefined } from '../../utils/getStringOrUndefined';

const prepareValue = (value) => {
  if (!value) {
    return value;
  }

  if (Array.isArray(value)) {
    return value.map((item) => {
      return { ...item, id: getStringOrUndefined(item.id) };
    });
  }

  return [{ ...value, id: getStringOrUndefined(value.id) }];
};

const getInitialValue = (field: (SuggestField | SuggestArrayField)['merged']) => {
  return prepareValue(field.data?.value);
};

export const createSuggestUsersAdapter = ({ isSingleValue }: { isSingleValue: boolean }) => {
  return {
    previewComponent(props) {
      return (
        <FormTextAlign as="div" size={props.size}>
          <ArrayPreviewDictionary value={props.field.data?.value} />
        </FormTextAlign>
      );
    },
    editComponent(props) {
      return (
        <Field
          name={props.field.type + props.field.id}
          component={UserSuggest}
          initialValue={getInitialValue(props.field)}
          getKey={(item) => getStringOrUndefined(item.id)}
          size={props.size}
          provider={props.field.provider}
          isSingleValue={isSingleValue}
        />
      );
    },
    getInitialValue,
  };
};
