import { Fields } from 'types/api/form/Fields';
import { Adapter } from '../types/Adapter';
import { AccountAdapter } from './Account';
import { DigitAdapter } from './Digit';
import { TextAdapter } from './Text';
import { TextareaAdapter } from './Textarea';
import { SelectAdapter } from './Select';
import { SelectArrayAdapter } from './SelectArray';
import { SuggestAdapter } from './Suggest';
import { SuggestArrayAdapter } from './SuggestArray';
import { SuggestUsersAdapter } from './SuggestUsers';
import { SuggestUsersArrayAdapter } from './SuggestUsersArray';
import { MoneyAdapter } from './Money';
import { DateTimeAdapter } from './DateTime';
import { CheckboxAdapter } from './Checkbox';
import { AvailabilityPeriodsAdapter } from './AvailabilityPeriods';
import { AudioAdapter } from './Audio';
import { SuggestTagArrayAdapter } from './SuggestTagArray';

export type Adapters = {
  [K in keyof Fields]: Adapter<Fields[K]['merged']>;
};

export const adapters: Partial<Adapters> = {
  Digit: DigitAdapter,
  Account: AccountAdapter,
  Text: TextAdapter,
  Textarea: TextareaAdapter,
  Select: SelectAdapter,
  SelectArray: SelectArrayAdapter,
  BusinessPlacementFrequency: SelectArrayAdapter,
  Suggest: SuggestAdapter,
  SuggestArray: SuggestArrayAdapter,
  SuggestUsers: SuggestUsersAdapter,
  SuggestUsersArray: SuggestUsersArrayAdapter,
  Money: MoneyAdapter,
  DateTime: DateTimeAdapter,
  Checkbox: CheckboxAdapter,
  AvailabilityPeriods: AvailabilityPeriodsAdapter,
  Audio: AudioAdapter,
  SuggestTagArray: SuggestTagArrayAdapter,
};
