import { Option } from 'types/api/form/Fields/Option';
import { getStringOrUndefined } from '../../utils/getStringOrUndefined';

const formatValue = (item) => {
  return {
    id: getStringOrUndefined(item.id),
    name: getStringOrUndefined(item.name),
  };
};

export const createSuggestAdapter = ({ isSingleValue }: { isSingleValue: boolean }) => (
  value: Option | Option[],
) => {
  if (Array.isArray(value)) {
    return { value: value.map(formatValue) };
  }

  if (value && value.id) {
    return {
      value: formatValue(value),
    };
  }

  if (isSingleValue) {
    return { value: {} };
  }

  return { value: [] };
};
