import { Option } from 'types/api/form/Fields/Option';
import { getStringOrUndefined } from '../../utils/getStringOrUndefined';

const formatValue = (item) => {
  return {
    id: getStringOrUndefined(item.id),
    name: getStringOrUndefined(item.name),
  };
};

export const createSuggestUsersAdapter = ({ isSingleValue }: { isSingleValue: boolean }) => (
  value: Option[],
) => {
  const res = value?.map(formatValue) || [];

  if (!isSingleValue) {
    return res;
  }

  return res[0] || {};
};
