import { Fields } from 'types/api/form/Fields';
import { AccountAdapter } from './Account';
import { DigitAdapter } from './Digit';
import { TextAdapter } from './Text';
import { TextareaAdapter } from './Textarea';
import { SelectAdapter } from './Select';
import { SelectArrayAdapter } from './SelectArray';
import { SuggestAdapter } from './Suggest';
import { SuggestArrayAdapter } from './SuggestArray';
import { SuggestUsersAdapter } from './SuggestUsers';
import { SuggestUsersArrayAdapter } from './SuggestUsersArray';
import { SuggestTagArrayAdapter } from './SuggestTagArray';
import { MoneyAdapter } from './Money';
import { DateTimeAdapter } from './DateTime';
import { CheckboxAdapter } from './Checkbox';

export type FormatForApiAdapters = {
  /* eslint-disable-next-line @typescript-eslint/no-explicit-any */
  [K in keyof Fields]: (value: any) => any;
};

export const formatForApiAdapters: Partial<FormatForApiAdapters> = {
  Digit: DigitAdapter,
  Account: AccountAdapter,
  Text: TextAdapter,
  Textarea: TextareaAdapter,
  Select: SelectAdapter,
  SelectArray: SelectArrayAdapter,
  BusinessPlacementFrequency: SelectArrayAdapter,
  Suggest: SuggestAdapter,
  SuggestArray: SuggestArrayAdapter,
  SuggestUsers: SuggestUsersAdapter,
  SuggestUsersArray: SuggestUsersArrayAdapter,
  SuggestTagArray: SuggestTagArrayAdapter,
  Money: MoneyAdapter,
  DateTime: DateTimeAdapter,
  Checkbox: CheckboxAdapter,
};
