import { AnyObject } from 'react-final-form';
import { Form } from 'types/api/form/Form';

export const fixFieldNameInValues = (values: AnyObject, scheme: Form): AnyObject => {
  return scheme.meta.fields.reduce((ac, field) => {
    ac[field.id] = values[field.type + field.id];

    return ac;
  }, {});
};
