import { Form, DataSet } from 'types/api/form/Form';
import { AnyObject } from 'react-final-form';
import { PartialBy } from 'utils/PartialBy';
import Access from 'utils/Access';
import isObject from 'lodash/isObject';
import { formatForApiAdapters } from '../formatForApiAdapters';

interface OptionalSendingFieldWrapper {
  optionalSendingField: boolean;
  needSend: boolean;
  value: AnyObject;
}

export const formatFormValuesToDataSet = (
  values: AnyObject,
  form?: Form,
  rowId?: string,
): PartialBy<DataSet, 'id'> => {
  const result: PartialBy<DataSet, 'id'> = {
    fields: [],
  };
  if (!form) {
    return result;
  }
  if (rowId) {
    result.id = rowId;
  }
  form.meta.fields
    .filter((field) => Access.isEdit(field.access))
    .filter((field) => Boolean(formatForApiAdapters[field.type]))
    .filter((field) => form.meta.fieldsVisibility.includes(field.id))
    .forEach((field) => {
      let value = values[field.type + field.id] as OptionalSendingFieldWrapper | undefined;
      if (isObject(value) && value.optionalSendingField) {
        if (value.needSend) {
          result.fields.push({
            type: field.type,
            id: field.id,
            data: formatForApiAdapters[field.type](value.value),
          });
        }
      } else {
        result.fields.push({
          type: field.type,
          id: field.id,
          data: formatForApiAdapters[field.type](value),
        });
      }
    });

  form.meta.fields
    .filter((field) => !form.meta.fieldsVisibility.includes(field.id))
    .forEach((field) => {
      result.fields.push({
        type: field.type,
        id: field.id,
        data: form.data[0].fields.find((f) => f.id === field.id)?.data,
      });
    });

  if (form.data.length === 1) {
    result.url = form.data[0].url;
  }
  return result;
};
