import { Form } from 'types/api/form/Form';
import { AnyObject } from 'react-final-form';
import { adapters } from '../adapters';

export const getInitialValues = (form: Form): AnyObject => {
  const result: AnyObject = {};
  const row = form.data[0];

  const fields = form.meta.fields.filter((field) => {
    const hasAdapter = Boolean(adapters[field.type]);
    const visible = form.meta.fieldsVisibility.includes(field.id);
    return hasAdapter && visible;
  });

  for (const fieldMeta of fields) {
    const fieldData = row.fields.find(({ id }) => id === fieldMeta.id);
    if (!fieldData) continue;

    const getInitialValue = adapters[fieldMeta.type].getInitialValue;
    if (getInitialValue) {
      const field = { ...fieldMeta, data: fieldData.data };
      result[fieldMeta.type + fieldMeta.id] = getInitialValue(field);
    }
  }

  return result;
};
