import { NormalizedArray } from 'types/NormalizedArray';

export function normalizedArrayToPlainArray<InputItemScheme>(
  array: number[],
  dict: NormalizedArray<InputItemScheme>['idsToEntities'],
): InputItemScheme[];

export function normalizedArrayToPlainArray<InputItemScheme, OutputItemScheme>(
  array: number[],
  dict: NormalizedArray<InputItemScheme>['idsToEntities'],
  format: (item: InputItemScheme) => OutputItemScheme,
): InputItemScheme[];

export function normalizedArrayToPlainArray(array, dict, format = (item) => item) {
  return array.filter((id) => Boolean(dict[id])).map((id) => format(dict[id]));
}
