import * as React from 'react';
import Button from '@crm/components/dist/lego2/Button';
import cx from 'classnames';
import Icon from '@crm/components/dist/lego2/Icon';
import css from './Group.module.css';

interface Props {
  show: boolean;
  header: React.ReactNode;
  children: React.ReactNode;
  onToggle: () => {};
}

const Group = (props: Props) => {
  const { show, header, children, onToggle } = props;
  return (
    <div className={cx(css.Group, { [css.Group__open]: show })}>
      <Button
        iconLeft={(iconCls) => (
          <Icon
            className={cx(iconCls, css.Group__buttonIcon)}
            type="arrow"
            direction={show ? 'top' : 'bottom'}
          />
        )}
        onClick={onToggle}
        view="clear"
        className={css.Group__button}
      >
        {header}
      </Button>
      {show && <div className={css.Group__content}>{children}</div>}
    </div>
  );
};

export default Group;
