import React from 'react';
import { connect } from 'react-redux';
import cx from 'classnames';
import { InfraBuzzer } from 'components/InfraBuzzer';
import UserInfo from 'modules/userInfo';
import BugReport from 'modules/bugReport';
import { Layout, Toggle } from 'modules/notifications';
import css from './Header.module.css';
import Services from './Services';
import MobileMenu from './MobileMenu';

interface ConnectedState {
  /* eslint-disable-next-line @typescript-eslint/no-explicit-any */
  info: any;
}

interface ConnectedProps {
  className?: string;
  theme?: 'side' | 'top';
}

type Props = ConnectedState & ConnectedProps;

const Header: React.FC<Props> = ({ info, className, theme = 'side' }) => {
  const modules = (info && info.modules) || {};

  if (info && info.user && info.user.login) {
    return (
      <header data-testid="side-menu" className={cx(css.header, className, css[`header_theme_${theme}`])}>
        <Layout />
        <div className={css.top}>
          <UserInfo
            info={info}
            hasDelegation={
              Array.isArray(info.availableDelegations) &&
              Boolean(info.availableDelegations.length) &&
              !info.realUser
            }
            isDelegation={Boolean(info.realUser)}
          />
          {modules.notifications && (
            <Toggle className={css.button} classNameActive={css.button_active} />
          )}
          {theme === 'side' && (
            <span className={css.serviceLinks}>
              <Services info={info} modules={modules} />
            </span>
          )}
        </div>
        <div className={css.bottom}>
          {theme === 'top' && <MobileMenu info={info} modules={modules} />}
          {theme === 'side' && (
            <InfraBuzzer
              className={css.button}
              fallback={<div className={css.button}>&nbsp;</div>}
            />
          )}
          {theme === 'side' && <BugReport className={css.button} />}
        </div>
      </header>
    );
  }
  return <header className={css.header} />;
};

const mapState = (state) => ({
  info: state.root.info,
});

export default connect<ConnectedState, null, ConnectedProps>(mapState)(Header);
