import React from 'react';
import { Router } from 'react-router-dom';
import { createHashHistory } from 'history';
import { storiesOf } from '@storybook/react';
import Icon from '@crm/components/dist/lego2/Icon';
import ModuleIcon from 'components/ModuleIcon';
import HeaderLink from './HeaderLink';

export const history = createHashHistory();

storiesOf('HeaderLink', module).add('ModuleLink', () => (
  <Router history={history}>
    <div style={{ padding: 20, background: '#000' }}>
      <span style={{ margin: 20 }}>
        <HeaderLink to="/" icon="account" title="account" />
      </span>
      <span style={{ margin: 20 }}>
        <HeaderLink
          to="/phone"
          icon={
            <ModuleIcon
              count={100}
              subIconTop={<Icon svg="work" style={{ color: 'red' }} />}
              icon={(cls) => <Icon className={cls} svg="phone" svgSize="l" />}
            />
          }
          title="phone"
        />
      </span>
    </div>
  </Router>
));
