import React from 'react';
import RouterLink, { RouterLinkProps } from 'components/RouterLink';
import ModuleIcon from 'components/ModuleIcon';
import Icon, { SvgIconType } from '@crm/components/dist/lego2/Icon';
import css from './Header.module.css';

interface HeaderLinkProps {
  to: string;
  icon: SvgIconType | React.ReactNode;
  title: string;
  customMatch?: RouterLinkProps['customMatch'];
  external?: boolean;
}

const HeaderLink: React.FC<HeaderLinkProps> = (props) => {
  const { to, icon, title, customMatch, external } = props;

  let moduleIcon = icon;
  if (typeof icon === 'string') {
    moduleIcon = (
      <ModuleIcon icon={(cls) => <Icon className={cls} svg={icon as SvgIconType} svgSize="l" />} />
    );
  }

  if (external) {
    return (
      <a href={to} className={css.linkIcon} title={title} target="_blank" rel="noopener noreferrer">
        {moduleIcon}
      </a>
    );
  }

  return (
    <RouterLink
      title={title}
      to={to}
      className={css.linkIcon}
      activeClassName={css.link_selected_color}
      customMatch={customMatch}
    >
      {moduleIcon}
    </RouterLink>
  );
};

export default HeaderLink;
