import React from 'react';
import ToolTip from 'lego/components/ToolTip';
import ModuleIcon from 'components/ModuleIcon';
import Icon from '@crm/components/dist/lego2/Icon';
import css from './HeaderSettingsIcon.module.css';

interface HeaderSettingsIconProps {
  isAutoreply?: boolean;
}

const HeaderSettingsIcon: React.FC<HeaderSettingsIconProps> = (props) => {
  const { isAutoreply } = props;

  return (
    <ModuleIcon
      icon={(cls) => <Icon className={cls} svgSize="l" svg="settings" />}
      subIconBottom={
        isAutoreply ? (
          <ToolTip className={css.subIcon} tooltip="Автоответ включен" stopPropagation padding="xs">
            А
          </ToolTip>
        ) : (
          undefined
        )
      }
    />
  );
};

export default HeaderSettingsIcon;
