import React, { useState, useCallback, useEffect } from 'react';
import { CSSTransition } from 'react-transition-group';
import { createPortal } from 'react-dom';
import Button from '@crm/components/dist/lego2/Button';
import Icon from '@crm/components/dist/lego2/Icon';
import cx from 'classnames';
import Services from './Services';
import css from './MobileMenu.module.css';

interface MobileMenuProps {
  modules: any;
  info: any;
}

const animClassNames = {
  enter: css.MobileMenu__wrap_state_enter,
  enterActive: css.MobileMenu__wrap_state_enterActive,
  exit: css.MobileMenu__wrap_state_exit,
  exitActive: css.MobileMenu__wrap_state_exitActive,
};

const MobileMenu: React.FC<MobileMenuProps> = (props) => {
  const [isOpen, open] = useState(false);

  const handleClose = useCallback(() => {
    open(false);
    document.removeEventListener('click', handleClose);
  }, []);

  const handleOpen = useCallback(() => {
    open(true);
    document.addEventListener('click', handleClose);
  }, [isOpen]);

  useEffect(() => {
    return () => {
      document.removeEventListener('click', handleClose);
    };
  }, []);

  return (
    <>
      <Button
        view="clear"
        className={css.MobileMenu__button}
        onClick={handleOpen}
        icon={(cls) => <Icon className={cx(cls, css.MobileMenu__icon)} svg="menu" />}
      />
      {createPortal(
        <CSSTransition in={isOpen} unmountOnExit timeout={300} classNames={animClassNames}>
          <div className={css.MobileMenu__wrap}>
            <div className={css.MobileMenu__content}>
              <Services {...props} />
            </div>
          </div>
        </CSSTransition>,
        document.body,
      )}
    </>
  );
};

export default MobileMenu;
