import React from 'react';
import { IssueModuleIcon } from 'modules/issues';
import { ModuleName } from 'modules/issues/types';
import { PERSONAL_DASHBOARD_ACCESS_KEY, PERSONAL_DASHBOARD_PATH } from 'modules/personalDashboard';
import { ROUTE_PATH as MEETINGS_ROUTE_PATH } from 'modules/meetings/constants';
import * as DTSLift from 'modules/dtsLift';
import { CallPopupContainer } from 'components/CallPopup/CallPopupContainer';
import { ROUTE_PATH as ISOLATION_ADMIN_ROUTE_PATH } from 'components/IsolationAdminModulePage';
import { config } from 'services/Config';
import { isAccountPath, PATH_ACCOUNTS } from 'pages/accounts';
import * as MailModule from 'pages/mail';
import { MODULE_NAME as SETTINGS_NAME, ROUTER_PATH as SETTINGS_PATH } from 'modules/settings';
import * as MASSMAIL from 'modules/massmail';
import * as Phone from 'modules/phone';
import { ROUTER_PATH as REVIEW_PATH, MODULE_NAME as REVIEW_NAME } from 'modules/review';
import HeaderLink from './HeaderLink';
import HeaderSettingsIcon from './HeaderSettingsIcon';
import { PersonalCallServiceProvider } from '../../services/PersonalCallService';
import css from './Services.module.css';

interface Props {
  modules: {
    accountList?: boolean;
    mail?: boolean;
    lift?: boolean;
    massmail?: boolean;
    issue?: boolean;
    ticket?: boolean;
    opportunity?: boolean;
    chat?: boolean;
    telephony?: boolean;
    mcsPhone?: boolean;
    reports?: boolean;
    isolationAdmin?: boolean;
    mcsReview?: boolean;
    planner?: boolean;
    personalDashboard?: boolean;
    settingsAccess?: {
      [key: string]: boolean;
    };
    adminAccess?: {
      [key: string]: boolean;
    };
    billing?: boolean;
  };
  info: {
    isAutoreply?: boolean;
  };
}

const accountListCustomMatch = ({ location }) => isAccountPath(location.pathname);
const Services: React.FC<Props> = (props) => {
  const { modules, info } = props;

  return (
    <PersonalCallServiceProvider>
      {modules.accountList && (
        <HeaderLink
          icon="account"
          customMatch={accountListCustomMatch}
          to={PATH_ACCOUNTS}
          title="Аккаунты"
        />
      )}
      {modules.mail && <HeaderLink icon={<MailModule.ModuleIcon />} to="/mail" title="Почта" />}
      {modules.lift && (
        <HeaderLink
          icon={<DTSLift.ModuleIcon />}
          to={DTSLift.constants.ROUTE_PATH}
          title="DTS Лифт"
        />
      )}
      {modules.massmail && (
        <HeaderLink icon="massmail" to={MASSMAIL.ROUTER_PATH} title={MASSMAIL.MODULE_NAME} />
      )}
      {modules.issue && <HeaderLink icon={<IssueModuleIcon />} to="/issues" title="Задачи" />}
      {modules.ticket && <HeaderLink icon="ticket" to={`/${ModuleName.Ticket}`} title="Тикеты" />}
      {modules.opportunity && (
        <HeaderLink icon="briefcase" to={`/${ModuleName.Opportunities}`} title="Сделки" />
      )}
      {modules.planner && (
        <HeaderLink icon="calendar" to={MEETINGS_ROUTE_PATH} title="Активности" />
      )}
      {modules.chat && <HeaderLink icon="question-answer" to="/chat" title="Чаты" />}
      {modules.telephony && <HeaderLink icon={<Phone.ModuleIcon />} to="/phone" title="Звонки" />}
      {modules.mcsPhone && (
        <HeaderLink
          icon="phone"
          to={`${window.CRM_SPACE_API_HOST}/phone/index.html`}
          external
          title="Телефонный"
        />
      )}
      {modules.reports && (
        <HeaderLink icon="excel" to="/mon/index.html#/webreports/get" external title="Мониторинг" />
      )}
      {modules.mcsReview && <HeaderLink icon="review" to={REVIEW_PATH} title={REVIEW_NAME} />}
      {modules.settingsAccess && modules.settingsAccess.any && (
        <HeaderLink
          icon={<HeaderSettingsIcon isAutoreply={info.isAutoreply} />}
          to={SETTINGS_PATH}
          title={SETTINGS_NAME}
        />
      )}
      {modules.isolationAdmin && (
        <HeaderLink
          icon={<div className={css.Services__adminIsolationIcon} />}
          to={ISOLATION_ADMIN_ROUTE_PATH}
          title="Админка изоляции"
        />
      )}
      {modules.adminAccess && modules.adminAccess.any && (
        <HeaderLink icon="lock" to="/admin" title="Админка" />
      )}
      {modules.billing && <HeaderLink icon="balance" to="/billing" title="Баланс" />}
      {modules[PERSONAL_DASHBOARD_ACCESS_KEY] && (
        <HeaderLink icon="personalDashboard" to={PERSONAL_DASHBOARD_PATH} title="ЛК менеджера" />
      )}
      {config.value.features.personalUnits && <CallPopupContainer />}
    </PersonalCallServiceProvider>
  );
};

export default Services;
