import React, { FC } from 'react';
import cx from 'classnames';
import { HiddenProps } from './Hidden.types';
import css from './Hidden.module.css';

export const Hidden: FC<HiddenProps> = ({ children, hidden, className, ...props }) => {
  return (
    <span className={cx(css.Hidden, className)} hidden={hidden} {...props}>
      {children}
    </span>
  );
};
