import React, { FC, HTMLAttributes } from 'react';
import cx from 'classnames';
import { withLoad, WithLoadInjectedProps } from 'hoc/withLoad';
import { IFrameApiResponse } from './IFrameLoadable.types';
import css from './IFrameLoadable.module.css';

const IFrameAdapter: FC<WithLoadInjectedProps<IFrameApiResponse> &
  HTMLAttributes<HTMLIFrameElement>> = ({ data, className, ...other }) => {
  return (
    <iframe
      {...other}
      data-testid="iframe-loadable"
      src={data.data.url}
      className={cx(css.IFrameLoadable, className)}
    />
  );
};

export const IFrameLoadable = withLoad(IFrameAdapter);
