import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';

const TYPE = {
  MATERIAL: 'MATERIAL',
  FONT_AWESOME: 'FONT_AWESOME',
};

const Icon = ({ type, name, className }) => {
  switch (type) {
    case (TYPE.FONT_AWESOME):
      return <i className={cx(`fa fa-${name}`, className)} aria-hidden />;
    default:
      return <i className={cx('material-icons', className)}>{name}</i>;
  }
};

Icon.TYPE = TYPE;
Icon.propTypes = {
  type: PropTypes.string,
  name: PropTypes.string,
  className: PropTypes.string,
};
Icon.defaultProps = {
  type: TYPE.MATERIAL,
  name: undefined,
  className: undefined,
};

export default Icon;

export const iconCreator = (config) => {
  const IconCreator = props => <Icon {...props} />;
  IconCreator.defaultProps = {
    ...config,
  };
  return IconCreator;
};
