import { createElement } from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import css from './Icon.scss';

const PACKS = {
  MATERIAL: 'material',
  FONTAWESOME: 'fontawesome',
};

const Icon = (props) => {
  const { pack, icon, className, fix, ...passPropsThrough } = props;

  let children;
  let extendClassName;
  if (pack === PACKS.MATERIAL) {
    extendClassName = cx('material-icons', className);
    children = icon;
  } else {
    extendClassName = cx(`fa fa-${icon}`, className, { [css.fa_fix]: fix });
  }

  return createElement('i', { className: extendClassName, ...passPropsThrough }, children);
};

Icon.PACKS = PACKS;

Icon.defaultProps = {
  fix: undefined,
};

Icon.propTypes = {
  pack: PropTypes.oneOf(['material', 'fontawesome', 'fa']),
  icon: PropTypes.string.isRequired,
  fix: PropTypes.bool,
};

export default Icon;
