import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import Icon from './Icon';
import css from './style.modules.scss';

const IconCallPersonal = props => {
  const { className, ...passPropsThrough } = props;

  return (
    <span className={cx(className, css.IconCompose)} {...passPropsThrough}>
      <Icon pack={Icon.PACKS.MATERIAL} className={css.IconCompose__main} icon="call" />
      <Icon pack={Icon.PACKS.MATERIAL} className={css.IconCompose__sub} icon="person" />
    </span>
  );
};

IconCallPersonal.propTypes = {
  className: PropTypes.string,
};

IconCallPersonal.defaultProps = {
  className: undefined,
};

export default IconCallPersonal;
