import * as React from 'react';
import { connect } from 'react-redux';
import { selectors } from './IframeSlice';
import css from './Iframe.module.css';

interface OwnProps {
  title: string;
}

interface ConnectedState {
  src?: string;
}

type Props = OwnProps & ConnectedState;

const Iframe: React.FC<Props> = props => {
  return <iframe className={css.iframe} title={props.title} src={props.src} />;
};

export default connect(
  (state): ConnectedState => ({
    src: selectors.getState(state),
  }),
)(Iframe);
