import React from 'react';
import { InfoTextBlock } from './InfoTextBlock';
import { InfoTextBlockThemes } from './InfoTextBlock.types';

export default {
  title: 'InfoTextBlock',
  component: InfoTextBlock,
  argTypes: {
    text: { control: { type: 'text' } },
    theme: {
      control: {
        options: InfoTextBlockThemes,
        type: 'select',
      },
    },
    icon: { control: { type: 'text' } },
  },
};

export const Default = (args) => <InfoTextBlock {...args} />;

Default.args = {
  text: 'Текст',
};
