import React from 'react';
import cx from 'classnames';
import Icon from '@crm/components/dist/lego2/Icon';
import { SvgIconType } from '@crm/components/dist/lego2/Icon/IconSvg';
import css from './InfoTextBlock.module.css';
import { InfoTextBlockProps, InfoTextBlockThemes } from './InfoTextBlock.types';

export const InfoTextBlock: React.FC<InfoTextBlockProps> = ({
  text,
  className,
  theme = InfoTextBlockThemes.info,
  icon,
}) => {
  const themeIcon = (icon ? icon : InfoTextBlockThemes[theme]) as SvgIconType;

  return (
    <blockquote className={cx(className, css.InfoTextBlock, css[`InfoTextBlock_theme_${theme}`])}>
      <Icon
        svg={themeIcon}
        svgSize="xl"
        className={cx(css.InfoTextBlock__icon, css[`InfoTextBlock__icon_theme_${theme}`])}
      />
      <p className={css.InfoTextBlock__text}>{text}</p>
    </blockquote>
  );
};
