import React from 'react';
import { InfraBuzzer as Component, INFRA_ENVIRONMENTS } from '@yandex-data-ui/infra-buzzer';
import cx from 'classnames';
import { InfraBuzzerProps } from './InfraBuzzer.types';
import { getPreset } from './InfraBuzzer.utils';
import './InfraBuzzer.css';

const InfraBuzzer: React.FC<InfraBuzzerProps> = (props) => {
  const preset = getPreset();

  return (
    <div className={cx(props.className, 'InfraBuzzer')}>
      <Component
        subscribeTo={{ preset }}
        environment={INFRA_ENVIRONMENTS.PRODUCTION}
        autoShowUpcomingEventsPopup
      />
    </div>
  );
};

export default InfraBuzzer;
