import React from 'react';
import PropTypes from 'prop-types';

export default class Input extends React.Component {
  static propTypes = {
    defaultValue: PropTypes.string,
  }

  static defaultProps = {
    defaultValue: '',
  }

  constructor(props) {
    super(props);

    this.state = {
      value: props.defaultValue,
    };
  }

  componentWillReceiveProps(nextProps) {
    if (nextProps.defaultValue !== this.props.defaultValue) {
      this.setState({
        value: nextProps.defaultValue,
      });
    }
  }

  value() {
    return this.input.value;
  }

  handleChange = (e) => {
    this.setState({ value: e.target.value });
  }

  inputRef = (node) => { this.input = node; }

  render() {
    const { defaultValue, ...other } = this.props;

    return (
      <input
        {...other}
        ref={this.inputRef}
        value={this.state.value}
        onChange={this.handleChange}
      />
    );
  }
}
