import React from 'react';
import IssueField from 'modules/issues/components/Issue/IssueField';
import { IssueFieldListProps } from './IssueFieldList.types';

export const IssueFieldList: React.FC<IssueFieldListProps> = ({
  classNames,
  fieldItem,
  name,
  onClick,
}) => {
  return (
    <div className={classNames?.container}>
      <div className={classNames?.title}>{fieldItem.text}</div>
      {fieldItem.items?.map((item) => (
        <IssueField
          key={item.val}
          name={name}
          component="Button2"
          fieldProps={{
            view: 'clear',
            onClick,
          }}
          className={classNames?.child}
          {...item}
        >
          {item.text}
        </IssueField>
      ))}
    </div>
  );
};
