import React from 'react';
import { Text } from '@crm/components/dist/lego2/Text';
import IssueField from 'modules/issues/components/Issue/IssueField';
import { IssueFieldPopupGroupProps } from './IssueFieldPopupGroup.types';
import { IssueFieldList } from './IssueFieldList';
import { IssueFieldWithPopup } from './IssueFieldWithPopup';

export const IssueFieldPopupGroup: React.FC<IssueFieldPopupGroupProps> = (props) => {
  const {
    buttonClassName,
    listClassNames,
    popupClassNames,
    groupMode,
    fieldItem,
    name,
    pin,
    onClick,
    size,
    isInRoller,
  } = props;

  if (fieldItem.items && fieldItem.items.length > 0) {
    switch (groupMode) {
      case 'popup':
        return (
          <IssueFieldWithPopup
            classNames={popupClassNames}
            fieldItem={fieldItem}
            name={name}
            pin={pin}
            onClick={onClick}
            size={size}
          />
        );
      case 'list':
        return (
          <IssueFieldList
            classNames={listClassNames}
            fieldItem={fieldItem}
            name={name}
            onClick={onClick}
          />
        );
    }
  }

  return (
    <IssueField
      name={name}
      component="Button2"
      fieldProps={{
        view: isInRoller && 'clear',
        size,
        pin,
        onClick,
      }}
      className={buttonClassName}
      {...fieldItem}
    >
      <Text typography="body-long-m" weight={isInRoller ? 'regular' : 'medium'} color="primary">
        {fieldItem.text}
      </Text>
    </IssueField>
  );
};
